import openpyxl
import numpy as np
import openmatrix as omx

OMXfile = omx.open_file('IMQ2013_macroaree.omx','w')   #Creazione del file OMX (w=writing a=append/edit)

zone = ['Torino','Cintura','Resto Provincia TO','Resto Piemonte','Esterno']   #Zonizzazione

for pop in ['TO','PIE']:
    for mez in ['Pr','Pu']:
        for per in ['IG','OP']:
            for sco in ['sr','']:
                if not (sco=='sr' and per=='OP'):   #Per ogni casistica popolazione/modo/periodo/scopo si determina il relativo file Excel
                    namedoc = 'IMQ2013_M'+mez+per+'_'+'Res'+pop+sco+'.xlsx'   #Costruzione del nome del file
                    excel_document = openpyxl.load_workbook(namedoc)   #Apertura del documento Excel
                    nsheet = excel_document.sheetnames   #Recupero dei nomi dei fogli presenti
                    sheet = excel_document[nsheet[0]]   #Caricamento del foglio di interesse (il primo)
                    rowmax = sheet.max_row   #Determinazione del numero di righe compilate
                    matrOD = np.zeros((5,5)) #Inizializzazione della matrice O/D
                    for i in range(9,rowmax):
                        matrOD[zone.index(sheet.cell(row=i,column=1).value)][zone.index(sheet.cell(row=i,column=3).value)]=sheet.cell(row=i,column=5).value #Compilazione della matrice O/D con i dati contenuti nel file
                    OMXfile['Res'+pop+'m'+mez+per+sco] = matrOD   #Scrittura della matrice sul file OMX
                    #Scrittura dei metadati complementari
                    OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Indagine = 'IMQ 2013'
                    if pop=='TO':
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Provincia di Torino'
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 32460
                    else:
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Regione Piemonte'
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 52119
                    if mez=='Pr':
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Privato'
                    else:
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Pubblico'
                    if per=='IG':
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Intera giornata'
                    else:
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Ora di punta (arrivo 07:43-08:42)'
                    if sco=='sr':
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti escluso ritorno'
                    else:
                        OMXfile['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti'

OMXfile.close()   #Chiusura del file creato